@extends('layouts.app')

@section('title', __('add_driver') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <nav class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.drivers.index') }}">{{ __('drivers') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('add_driver') }}</span>
            </nav>
            <h1 class="create-page-title">
                <span class="create-page-title-icon">
                    <i class="bi bi-plus-circle"></i>
                </span>
                {{ __('add_driver') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Register a new driver in the system') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.drivers.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('back') }}
            </a>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <form action="{{ route('admin.drivers.store') }}" method="POST">
        @csrf

        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Basic Information --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-person-circle"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">{{ __('Basic Information') }}</h3>
                            <p class="create-card-subtitle">{{ __('Driver personal details') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="name" class="create-form-label">
                                    {{ __('driver_name') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="text" 
                                       class="create-input @error('name') is-invalid @enderror" 
                                       id="name" 
                                       name="name" 
                                       value="{{ old('name') }}" 
                                       placeholder="{{ __('Full Name') }}" 
                                       required>
                                @error('name')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                                <span class="create-form-hint">{{ __('Enter driver\'s full legal name') }}</span>
                            </div>
                            <div class="create-form-group">
                                <label for="mobile" class="create-form-label">
                                    {{ __('mobile') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="tel" 
                                       class="create-input @error('mobile') is-invalid @enderror" 
                                       id="mobile" 
                                       name="mobile" 
                                       value="{{ old('mobile') }}" 
                                       placeholder="+91 98765 43210" 
                                       required>
                                @error('mobile')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                                <span class="create-form-hint">{{ __('Primary contact number') }}</span>
                            </div>
                        </div>
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="password" class="create-form-label">
                                    {{ __('password') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="password" 
                                       class="create-input @error('password') is-invalid @enderror" 
                                       id="password" 
                                       name="password" 
                                       required>
                                @error('password')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                                <span class="create-form-hint">{{ __('For mobile app login (min 6 characters)') }}</span>
                            </div>
                            <div class="create-form-group">
                                <label for="license_number" class="create-form-label">
                                    {{ __('license_number') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="text" 
                                       class="create-input @error('license_number') is-invalid @enderror" 
                                       id="license_number" 
                                       name="license_number" 
                                       value="{{ old('license_number') }}" 
                                       placeholder="DL-123456789" 
                                       required>
                                @error('license_number')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                                <span class="create-form-hint">{{ __('Valid driving license number') }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Driver Type & Vehicle --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-truck-front"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">{{ __('Driver Type & Vehicle') }}</h3>
                            <p class="create-card-subtitle">{{ __('Assignment configuration') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        @if($availableVehicles->isEmpty())
                            <div class="create-alert create-alert-warning">
                                <div class="create-alert-icon">
                                    <i class="bi bi-exclamation-triangle"></i>
                                </div>
                                <div class="create-alert-content">
                                    <h6 class="create-alert-title">{{ __('No Vehicles Available') }}</h6>
                                    <p class="create-alert-text">{{ __('All vehicles are already assigned to drivers. You can only create "Driver Only" type drivers.') }}</p>
                                </div>
                            </div>
                        @endif

                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="driver_type" class="create-form-label">
                                    {{ __('driver_type') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select class="create-select @error('driver_type') is-invalid @enderror" 
                                        id="driver_type" 
                                        name="driver_type" 
                                        required>
                                    <option value="">{{ __('select_option') }}</option>
                                    <option value="driver_only" {{ old('driver_type') === 'driver_only' ? 'selected' : '' }}>
                                        {{ __('driver_only') }} - {{ __('Driver without own vehicle') }}
                                    </option>
                                    <option value="own_vehicle" {{ old('driver_type') === 'own_vehicle' ? 'selected' : '' }}>
                                        {{ __('own_vehicle') }} - {{ __('Driver with own vehicle') }}
                                    </option>
                                </select>
                                @error('driver_type')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                                <span class="create-form-hint">{{ __('Select driver classification') }}</span>
                            </div>
                            <div class="create-form-group" id="vehicle_field" style="display: none;">
                                <label for="own_vehicle_id" class="create-form-label">
                                    {{ __('vehicle') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select class="create-select @error('own_vehicle_id') is-invalid @enderror" 
                                        id="own_vehicle_id" 
                                        name="own_vehicle_id">
                                    <option value="">{{ __('select_option') }}</option>
                                    @foreach($availableVehicles as $vehicle)
                                        <option value="{{ $vehicle->id }}" {{ old('own_vehicle_id') == $vehicle->id ? 'selected' : '' }}>
                                            {{ $vehicle->vehicle_number }} - {{ $vehicle->vehicleType->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('own_vehicle_id')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                                <span class="create-form-hint">{{ __('Only vehicles without assigned drivers') }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Status & Contact --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon success">
                            <i class="bi bi-gear"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">{{ __('Status & Contact') }}</h3>
                            <p class="create-card-subtitle">{{ __('Additional driver information') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="status" class="create-form-label">
                                    {{ __('status') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select class="create-select @error('status') is-invalid @enderror" 
                                        id="status" 
                                        name="status" 
                                        required>
                                    <option value="active" {{ old('status', 'active') === 'active' ? 'selected' : '' }}>
                                        {{ __('active') }}
                                    </option>
                                    <option value="inactive" {{ old('status') === 'inactive' ? 'selected' : '' }}>
                                        {{ __('inactive') }}
                                    </option>
                                </select>
                                @error('status')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="emergency_contact" class="create-form-label">
                                    {{ __('emergency_contact') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <input type="tel" 
                                       class="create-input @error('emergency_contact') is-invalid @enderror" 
                                       id="emergency_contact" 
                                       name="emergency_contact" 
                                       value="{{ old('emergency_contact') }}" 
                                       placeholder="+91 98765 00000">
                                @error('emergency_contact')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                                <span class="create-form-hint">{{ __('Emergency contact number') }}</span>
                            </div>
                        </div>
                        <div class="create-form-group">
                            <label for="address" class="create-form-label">
                                {{ __('address') }}
                                <span class="create-form-optional">({{ __('Optional') }})</span>
                            </label>
                            <textarea class="create-textarea @error('address') is-invalid @enderror" 
                                      id="address" 
                                      name="address" 
                                      rows="3" 
                                      placeholder="{{ __('Full address...') }}">{{ old('address') }}</textarea>
                            @error('address')
                                <span class="create-form-error">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    {{-- Form Actions --}}
                    <div class="create-card-actions">
                        <div class="create-card-actions-left">
                            <a href="{{ route('admin.drivers.index') }}" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-lg"></i>
                                {{ __('cancel') }}
                            </a>
                        </div>
                        <div class="create-card-actions-right">
                            <button type="submit" class="create-btn create-btn-primary">
                                <i class="bi bi-check-lg"></i>
                                {{ __('save') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Quick Tips --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-lightbulb"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Quick Tips') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Driver name should match their ID document') }}
                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Mobile number is used for app login') }}
                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Password must be at least 6 characters') }}
                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Own Vehicle drivers are tied to specific vehicles') }}
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Driver Types --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Driver Types') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            <span class="create-status-badge" style="background-color: rgba(13, 110, 253, 0.1); color: #0d6efd;">
                                <i class="bi bi-truck-front"></i>
                                {{ __('own_vehicle') }}
                            </span>
                            <p class="create-status-description">{{ __('Driver owns and operates their specific vehicle') }}</p>
                        </div>
                        <div class="create-status-preview">
                            <span class="create-status-badge" style="background-color: rgba(13, 202, 240, 0.1); color: #0dcaf0;">
                                <i class="bi bi-person"></i>
                                {{ __('driver_only') }}
                            </span>
                            <p class="create-status-description">{{ __('Driver can be assigned to any available vehicle') }}</p>
                        </div>
                    </div>
                </div>

                {{-- Quick Actions --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Quick Actions') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.drivers.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Drivers') }}
                            </a>
                            <a href="{{ route('admin.vehicles.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-truck"></i>
                                {{ __('Manage Vehicles') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const driverType = document.getElementById('driver_type');
    const vehicleField = document.getElementById('vehicle_field');
    const vehicleSelect = document.getElementById('own_vehicle_id');

    function toggleVehicleField() {
        if (driverType.value === 'own_vehicle') {
            vehicleField.style.display = 'block';
            vehicleSelect.required = true;
        } else {
            vehicleField.style.display = 'none';
            vehicleSelect.required = false;
            vehicleSelect.value = '';
        }
    }

    // Initial check
    toggleVehicleField();

    // Listen for changes
    driverType.addEventListener('change', toggleVehicleField);
});
</script>
@endpush