@extends('layouts.app')

@section('title', __('edit') . ' ' . __('driver') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <nav class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.drivers.index') }}">{{ __('drivers') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('edit') }} - {{ $driver->name }}</span>
            </nav>
            <h1 class="create-page-title">
                <span class="create-page-title-icon">
                    <i class="bi bi-pencil-square"></i>
                </span>
                {{ __('edit') }} {{ __('driver') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Update driver information for') }}: {{ $driver->name }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.drivers.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('back') }}
            </a>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Active Trip Warning --}}
    @if($driver->trips()->whereIn('status', ['assigned', 'in_transit'])->exists())
        <div class="create-alert create-alert-warning mb-4">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <h6 class="create-alert-title">{{ __('Active Trips') }}</h6>
                <p class="create-alert-text">{{ __('This driver has active trips. Be cautious when changing status or vehicle assignment.') }}</p>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.drivers.update', $driver) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Basic Information --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-person-circle"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">{{ __('Basic Information') }}</h3>
                            <p class="create-card-subtitle">{{ __('Driver personal details') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="name" class="create-form-label">
                                    {{ __('driver_name') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="text" 
                                       class="create-input @error('name') is-invalid @enderror" 
                                       id="name" 
                                       name="name" 
                                       value="{{ old('name', $driver->name) }}" 
                                       placeholder="{{ __('Full Name') }}" 
                                       required>
                                @error('name')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="mobile" class="create-form-label">
                                    {{ __('mobile') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="tel" 
                                       class="create-input @error('mobile') is-invalid @enderror" 
                                       id="mobile" 
                                       name="mobile" 
                                       value="{{ old('mobile', $driver->mobile) }}" 
                                       placeholder="+91 98765 43210" 
                                       required>
                                @error('mobile')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="password" class="create-form-label">
                                    {{ __('password') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <input type="password" 
                                       class="create-input @error('password') is-invalid @enderror" 
                                       id="password" 
                                       name="password">
                                @error('password')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                                <span class="create-form-hint">{{ __('Leave blank to keep current password') }}</span>
                            </div>
                            <div class="create-form-group">
                                <label for="license_number" class="create-form-label">
                                    {{ __('license_number') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="text" 
                                       class="create-input @error('license_number') is-invalid @enderror" 
                                       id="license_number" 
                                       name="license_number" 
                                       value="{{ old('license_number', $driver->license_number) }}" 
                                       placeholder="DL-123456789" 
                                       required>
                                @error('license_number')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Driver Type & Vehicle --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-truck-front"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">{{ __('Driver Type & Vehicle') }}</h3>
                            <p class="create-card-subtitle">{{ __('Assignment configuration') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="driver_type" class="create-form-label">
                                    {{ __('driver_type') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select class="create-select @error('driver_type') is-invalid @enderror" 
                                        id="driver_type" 
                                        name="driver_type" 
                                        required>
                                    <option value="">{{ __('select_option') }}</option>
                                    <option value="driver_only" {{ old('driver_type', $driver->driver_type) === 'driver_only' ? 'selected' : '' }}>
                                        {{ __('driver_only') }} - {{ __('Driver without own vehicle') }}
                                    </option>
                                    <option value="own_vehicle" {{ old('driver_type', $driver->driver_type) === 'own_vehicle' ? 'selected' : '' }}>
                                        {{ __('own_vehicle') }} - {{ __('Driver with own vehicle') }}
                                    </option>
                                </select>
                                @error('driver_type')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="create-form-group" id="vehicle_field" 
                                 style="display: {{ old('driver_type', $driver->driver_type) === 'own_vehicle' ? 'block' : 'none' }};">
                                <label for="own_vehicle_id" class="create-form-label">
                                    {{ __('vehicle') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select class="create-select @error('own_vehicle_id') is-invalid @enderror" 
                                        id="own_vehicle_id" 
                                        name="own_vehicle_id">
                                    <option value="">{{ __('select_option') }}</option>
                                    @foreach($availableVehicles as $vehicle)
                                        <option value="{{ $vehicle->id }}" {{ old('own_vehicle_id', $driver->own_vehicle_id) == $vehicle->id ? 'selected' : '' }}>
                                            {{ $vehicle->vehicle_number }} - {{ $vehicle->vehicleType->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('own_vehicle_id')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                                <span class="create-form-hint">{{ __('Only vehicles without assigned drivers') }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Status & Contact --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon success">
                            <i class="bi bi-gear"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">{{ __('Status & Contact') }}</h3>
                            <p class="create-card-subtitle">{{ __('Additional driver information') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="status" class="create-form-label">
                                    {{ __('status') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select class="create-select @error('status') is-invalid @enderror" 
                                        id="status" 
                                        name="status" 
                                        required>
                                    <option value="active" {{ old('status', $driver->status) === 'active' ? 'selected' : '' }}>
                                        {{ __('active') }}
                                    </option>
                                    <option value="inactive" {{ old('status', $driver->status) === 'inactive' ? 'selected' : '' }}>
                                        {{ __('inactive') }}
                                    </option>
                                    <option value="on_trip" {{ old('status', $driver->status) === 'on_trip' ? 'selected' : '' }}>
                                        {{ __('on_trip') }}
                                    </option>
                                </select>
                                @error('status')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="emergency_contact" class="create-form-label">
                                    {{ __('emergency_contact') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <input type="tel" 
                                       class="create-input @error('emergency_contact') is-invalid @enderror" 
                                       id="emergency_contact" 
                                       name="emergency_contact" 
                                       value="{{ old('emergency_contact', $driver->emergency_contact) }}" 
                                       placeholder="+91 98765 00000">
                                @error('emergency_contact')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="create-form-group">
                            <label for="address" class="create-form-label">
                                {{ __('address') }}
                                <span class="create-form-optional">({{ __('Optional') }})</span>
                            </label>
                            <textarea class="create-textarea @error('address') is-invalid @enderror" 
                                      id="address" 
                                      name="address" 
                                      rows="3" 
                                      placeholder="{{ __('Full address...') }}">{{ old('address', $driver->address) }}</textarea>
                            @error('address')
                                <span class="create-form-error">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    {{-- Form Actions --}}
                    <div class="create-card-actions">
                        <div class="create-card-actions-left">
                            <a href="{{ route('admin.drivers.index') }}" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-lg"></i>
                                {{ __('cancel') }}
                            </a>
                        </div>
                        <div class="create-card-actions-right">
                            <button type="submit" class="create-btn create-btn-primary">
                                <i class="bi bi-check-lg"></i>
                                {{ __('save') }}
                            </button>
                        </div>
                    </div>
                </div>

                {{-- Recent Trips --}}
                @if($driver->trips()->count() > 0)
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-geo-alt"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">{{ __('Recent Trips') }}</h3>
                            <p class="create-card-subtitle">{{ __('Last 5 trips by this driver') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>{{ __('Trip #') }}</th>
                                        <th>{{ __('Vehicle') }}</th>
                                        <th>{{ __('Shipment Ref') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Date') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($driver->trips()->latest()->take(5)->get() as $trip)
                                    <tr>
                                        <td><strong>{{ $trip->trip_number }}</strong></td>
                                        <td>{{ $trip->vehicle->vehicle_number }}</td>
                                        <td>{{ $trip->shipment_reference ?? '-' }}</td>
                                        <td>
                                            <span class="badge {{ statusBadgeClass($trip->status) }}">
                                                {{ __($trip->status) }}
                                            </span>
                                        </td>
                                        <td>{{ $trip->created_at->format('M d, Y') }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <a href="{{ route('admin.trips.index', ['driver_id' => $driver->id]) }}" class="create-btn create-btn-secondary mt-3">
                            {{ __('View All Trips') }} <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
                @endif
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Driver Info --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-person-badge"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Driver Info') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                <i class="bi bi-person fs-4"></i>
                            </div>
                            <div>
                                <h6 class="mb-0">{{ $driver->name }}</h6>
                                <small class="text-muted">{{ $driver->mobile }}</small>
                            </div>
                        </div>
                        <div class="create-status-preview">
                            @if($driver->isAvailable())
                                <span class="create-status-badge" style="background-color: rgba(25, 135, 84, 0.1); color: #198754;">
                                    <i class="bi bi-check-circle"></i>
                                    {{ __('Available') }}
                                </span>
                            @else
                                <span class="create-status-badge" style="background-color: rgba(220, 53, 69, 0.1); color: #dc3545;">
                                    <i class="bi bi-x-circle"></i>
                                    {{ __('Not Available') }}
                                </span>
                            @endif
                        </div>
                    </div>
                </div>

                {{-- Trip Statistics --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-graph-up"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Trip Statistics') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="list-unstyled mb-0">
                            <li class="d-flex justify-content-between align-items-center mb-2 pb-2 border-bottom">
                                <span class="text-muted">{{ __('Total Trips') }}</span>
                                <span class="badge bg-primary">{{ $driver->trips()->count() }}</span>
                            </li>
                            <li class="d-flex justify-content-between align-items-center mb-2 pb-2 border-bottom">
                                <span class="text-muted">{{ __('Active Trips') }}</span>
                                <span class="badge bg-warning">{{ $driver->trips()->whereIn('status', ['assigned', 'in_transit'])->count() }}</span>
                            </li>
                            <li class="d-flex justify-content-between align-items-center">
                                <span class="text-muted">{{ __('Completed Trips') }}</span>
                                <span class="badge bg-success">{{ $driver->trips()->where('status', 'delivered')->count() }}</span>
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Record Info --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-clock-history"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Record Info') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="list-unstyled mb-0">
                            <li class="d-flex justify-content-between mb-2 pb-2 border-bottom">
                                <span class="text-muted">{{ __('Created') }}</span>
                                <span>{{ $driver->created_at->format('M d, Y') }}</span>
                            </li>
                            <li class="d-flex justify-content-between mb-2 pb-2 border-bottom">
                                <span class="text-muted">{{ __('Updated') }}</span>
                                <span>{{ $driver->updated_at->format('M d, Y') }}</span>
                            </li>
                            @if($driver->emergency_contact)
                            <li class="d-flex justify-content-between">
                                <span class="text-muted">{{ __('Emergency') }}</span>
                                <span>{{ $driver->emergency_contact }}</span>
                            </li>
                            @endif
                        </ul>
                    </div>
                </div>

                {{-- Quick Actions --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Quick Actions') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.drivers.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Drivers') }}
                            </a>
                            <a href="{{ route('admin.drivers.create') }}" class="create-quick-action-btn">
                                <i class="bi bi-plus-circle"></i>
                                {{ __('Add New Driver') }}
                            </a>
                            <a href="{{ route('admin.trips.index', ['driver_id' => $driver->id]) }}" class="create-quick-action-btn">
                                <i class="bi bi-geo-alt"></i>
                                {{ __('View Driver Trips') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const driverType = document.getElementById('driver_type');
    const vehicleField = document.getElementById('vehicle_field');
    const vehicleSelect = document.getElementById('own_vehicle_id');

    function toggleVehicleField() {
        if (driverType.value === 'own_vehicle') {
            vehicleField.style.display = 'block';
            vehicleSelect.required = true;
        } else {
            vehicleField.style.display = 'none';
            vehicleSelect.required = false;
            vehicleSelect.value = '';
        }
    }

    // Listen for changes
    driverType.addEventListener('change', toggleVehicleField);
});
</script>
@endpush