@extends('layouts.app')

@section('title', __('drivers') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header --}}
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-people"></i>
                {{ __('drivers') }}
            </h1>
            <p class="list-page-subtitle">{{ __('Manage driver information and vehicle assignments') }}</p>
        </div>
        <div class="list-page-header-actions">
            <a href="{{ route('admin.drivers.create') }}" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                {{ __('add_driver') }}
            </a>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Stats Bar --}}
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-people"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $drivers->total() }}</div>
                <div class="list-stat-label">{{ __('Total Drivers') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-database"></i>
                {{ __('All records') }}
            </div>
        </div>
        <div class="list-stat-card gradient-green">
            <div class="list-stat-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $drivers->where('status', 'active')->count() }}</div>
                <div class="list-stat-label">{{ __('active') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-person-check"></i>
                {{ __('Available') }}
            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-truck"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $drivers->where('status', 'on_trip')->count() }}</div>
                <div class="list-stat-label">{{ __('on_trip') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-geo-alt"></i>
                {{ __('On route') }}
            </div>
        </div>
        <div class="list-stat-card gradient-blue">
            <div class="list-stat-icon">
                <i class="bi bi-truck-front"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $drivers->where('driver_type', 'own_vehicle')->count() }}</div>
                <div class="list-stat-label">{{ __('own_vehicle') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-key"></i>
                {{ __('With vehicle') }}
            </div>
        </div>
    </div>

    {{-- Filter Bar --}}
    <div class="list-filter-bar">
        <form action="{{ route('admin.drivers.index') }}" method="GET">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <div class="list-search-box">
                        <input type="text" 
                               name="search" 
                               placeholder="{{ __('search') }} {{ __('driver_name') }}, {{ __('mobile') }}..." 
                               value="{{ request('search') }}">
                        <i class="bi bi-search"></i>
                    </div>
                </div>
                <div class="list-filter-group">
                    <select name="driver_type" class="form-select">
                        <option value="">{{ __('driver_type') }} - {{ __('All') }}</option>
                        <option value="own_vehicle" {{ request('driver_type') === 'own_vehicle' ? 'selected' : '' }}>
                            {{ __('own_vehicle') }}
                        </option>
                        <option value="driver_only" {{ request('driver_type') === 'driver_only' ? 'selected' : '' }}>
                            {{ __('driver_only') }}
                        </option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <select name="status" class="form-select">
                        <option value="">{{ __('status') }} - {{ __('All') }}</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>
                            {{ __('active') }}
                        </option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>
                            {{ __('inactive') }}
                        </option>
                        <option value="on_trip" {{ request('status') === 'on_trip' ? 'selected' : '' }}>
                            {{ __('on_trip') }}
                        </option>
                    </select>
                </div>
                <div class="list-filter-buttons">
                    <button type="submit" class="btn-filter btn-filter-primary">
                        <i class="bi bi-funnel"></i>
                        {{ __('filter') }}
                    </button>
                    <a href="{{ route('admin.drivers.index') }}" class="btn-filter btn-filter-outline">
                        <i class="bi bi-x-circle"></i>
                        {{ __('clear') }}
                    </a>
                </div>
            </div>
        </form>
    </div>

    {{-- Drivers Table --}}
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                <i class="bi bi-table me-2"></i>
                {{ __('drivers') }}
                <span class="list-table-count">({{ $drivers->total() }} {{ __('records') }})</span>
            </h5>
        </div>

        @if($drivers->isEmpty())
            <div class="list-empty-state">
                <div class="list-empty-icon">
                    <i class="bi bi-people"></i>
                </div>
                <h4>{{ __('no_records') }}</h4>
                <p>{{ __('No drivers found. Add your first driver to get started.') }}</p>
                <a href="{{ route('admin.drivers.create') }}" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    {{ __('add_driver') }}
                </a>
            </div>
        @else
            <div class="table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th>{{ __('driver_name') }}</th>
                            <th>{{ __('mobile') }}</th>
                            <th>{{ __('license_number') }}</th>
                            <th>{{ __('driver_type') }}</th>
                            <th>{{ __('vehicle') }}</th>
                            <th>{{ __('status') }}</th>
                            <th class="text-center">{{ __('actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($drivers as $driver)
                        <tr>
                            <td>
                                <div class="table-cell-user">
                                    <div class="table-cell-user-avatar">
                                        <i class="bi bi-person"></i>
                                    </div>
                                    <div>
                                        <strong>{{ $driver->name }}</strong>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="table-cell-date">
                                    <i class="bi bi-telephone"></i>
                                    {{ $driver->mobile }}
                                </span>
                            </td>
                            <td>
                                <code>{{ $driver->license_number }}</code>
                            </td>
                            <td>
                                @if($driver->driver_type === 'own_vehicle')
                                    <span class="table-badge table-badge-assigned">
                                        <i class="bi bi-truck-front"></i>
                                        {{ __('own_vehicle') }}
                                    </span>
                                @else
                                    <span class="table-badge table-badge-info">
                                        <i class="bi bi-person"></i>
                                        {{ __('driver_only') }}
                                    </span>
                                @endif
                            </td>
                            <td>
                                @if($driver->ownVehicle)
                                    <span class="table-badge table-badge-in-transit">
                                        <i class="bi bi-truck"></i>
                                        {{ $driver->ownVehicle->vehicle_number }}
                                    </span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @if($driver->status === 'active')
                                    <span class="table-badge table-badge-delivered">
                                        <i class="bi bi-check-circle"></i>
                                        {{ __('active') }}
                                    </span>
                                @elseif($driver->status === 'inactive')
                                    <span class="table-badge table-badge-cancelled">
                                        <i class="bi bi-x-circle"></i>
                                        {{ __('inactive') }}
                                    </span>
                                @elseif($driver->status === 'on_trip')
                                    <span class="table-badge table-badge-pending">
                                        <i class="bi bi-truck"></i>
                                        {{ __('on_trip') }}
                                    </span>
                                @endif
                            </td>
                            <td>
                                <div class="table-actions">
                                    <a href="{{ route('admin.drivers.edit', $driver) }}" 
                                       class="btn-table-action btn-table-edit" 
                                       title="{{ __('edit') }}">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="{{ route('admin.drivers.destroy', $driver) }}" 
                                          method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" 
                                                class="btn-table-action btn-table-delete delete-confirm" 
                                                title="{{ __('delete') }}">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            @if($drivers->hasPages())
            <div class="list-pagination">
                <div class="pagination-info">
                    {{ __('Showing') }} {{ $drivers->firstItem() }} {{ __('to') }} {{ $drivers->lastItem() }} {{ __('of') }} {{ $drivers->total() }} {{ __('entries') }}
                </div>
                <div class="pagination-links">
                    {{ $drivers->links() }}
                </div>
            </div>
            @endif
        @endif
    </div>
</div>
@endsection