@extends('layouts.app')

@section('title', __('roles') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header --}}
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-shield-lock"></i>
                {{ __('roles') }}
            </h1>
            <p class="list-page-subtitle">{{ __('Manage user roles and permissions') }}</p>
        </div>
        <div class="list-page-header-actions">
            <a href="{{ route('admin.roles.create') }}" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                {{ __('add_role') }}
            </a>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Stats Bar --}}
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-violet">
            <div class="list-stat-icon">
                <i class="bi bi-shield-lock"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $roles->total() }}</div>
                <div class="list-stat-label">{{ __('Total Roles') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-database"></i>
                {{ __('All records') }}
            </div>
        </div>
        <div class="list-stat-card gradient-green">
            <div class="list-stat-icon">
                <i class="bi bi-people"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $roles->sum('users_count') }}</div>
                <div class="list-stat-label">{{ __('Total Users') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-person-check"></i>
                {{ __('Assigned') }}
            </div>
        </div>
        <div class="list-stat-card gradient-amber">
            <div class="list-stat-icon">
                <i class="bi bi-key"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $roles->sum(fn($r) => $r->permissions->count()) }}</div>
                <div class="list-stat-label">{{ __('Permissions') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-check-circle"></i>
                {{ __('Granted') }}
            </div>
        </div>
        <div class="list-stat-card gradient-blue">
            <div class="list-stat-icon">
                <i class="bi bi-star"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $roles->where('name', 'super_admin')->count() }}</div>
                <div class="list-stat-label">{{ __('Super Admin') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-shield-check"></i>
                {{ __('Full Access') }}
            </div>
        </div>
    </div>

    {{-- Roles Table --}}
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                <i class="bi bi-table me-2"></i>
                {{ __('roles') }}
                <span class="list-table-count">({{ $roles->total() }} {{ __('records') }})</span>
            </h5>
        </div>

        @if($roles->count() > 0)
            <div class="table-responsive">
                <table class="list-table">
                    <thead>
                        <tr>
                            <th>{{ __('name') }}</th>
                            <th>{{ __('display_name') }}</th>
                            <th>{{ __('description') }}</th>
                            <th>{{ __('users_count') }}</th>
                            <th>{{ __('permissions_count') }}</th>
                            <th>{{ __('created_at') }}</th>
                            <th class="text-center">{{ __('actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($roles as $role)
                        <tr>
                            <td>
                                <span class="table-badge table-badge-assigned">
                                    <i class="bi bi-shield"></i>
                                    {{ $role->name }}
                                </span>
                            </td>
                            <td>
                                <div class="table-cell-user">
                                    <div class="table-cell-user-avatar">
                                        <i class="bi bi-shield-lock"></i>
                                    </div>
                                    <div>
                                        <strong>{{ $role->display_name }}</strong>
                                        @if($role->name === 'super_admin')
                                            <span class="badge bg-warning ms-1">{{ __('System') }}</span>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="text-muted">{{ $role->description ?? '-' }}</span>
                            </td>
                            <td>
                                <span class="table-badge table-badge-pending">
                                    <i class="bi bi-people"></i>
                                    {{ $role->users_count }} {{ __('users') }}
                                </span>
                            </td>
                            <td>
                                <span class="table-badge table-badge-in-transit">
                                    <i class="bi bi-key"></i>
                                    {{ $role->permissions->count() }} {{ __('permissions') }}
                                </span>
                            </td>
                            <td>
                                <span class="table-cell-date">
                                    <i class="bi bi-calendar"></i>
                                    {{ $role->created_at->format('d M Y') }}
                                </span>
                            </td>
                            <td>
                                <div class="table-actions">
                                    <a href="{{ route('admin.roles.edit', $role) }}" 
                                       class="btn-table-action btn-table-edit" 
                                       title="{{ __('edit') }}">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    @if($role->name !== 'super_admin')
                                        <form action="{{ route('admin.roles.destroy', $role) }}" 
                                              method="POST" 
                                              class="d-inline"
                                              onsubmit="return confirm('{{ __('are_you_sure') }}');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" 
                                                    class="btn-table-action btn-table-delete" 
                                                    title="{{ __('delete') }}">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            @if($roles->hasPages())
            <div class="list-pagination">
                <div class="pagination-info">
                    {{ __('Showing') }} {{ $roles->firstItem() }} {{ __('to') }} {{ $roles->lastItem() }} {{ __('of') }} {{ $roles->total() }} {{ __('entries') }}
                </div>
                <div class="pagination-links">
                    {{ $roles->links() }}
                </div>
            </div>
            @endif
        @else
            <div class="list-empty-state">
                <div class="list-empty-icon">
                    <i class="bi bi-shield-lock"></i>
                </div>
                <h4>{{ __('no_roles_found') }}</h4>
                <p>{{ __('No roles found. Create your first role to get started.') }}</p>
                <a href="{{ route('admin.roles.create') }}" class="btn-create">
                    <i class="bi bi-plus-lg"></i>
                    {{ __('add_role') }}
                </a>
            </div>
        @endif
    </div>
</div>
@endsection