@extends('layouts.app')

@section('title', __('Edit Shipment') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <div class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.shipments.index') }}">{{ __('Shipments') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.shipments.show', $shipment) }}">{{ $shipment->shipment_number }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('Edit') }}</span>
            </div>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-pencil"></i>
                </div>
                {{ __('Edit Shipment') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Update the shipment details below') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.shipments.show', $shipment) }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('Back to Details') }}
            </a>
        </div>
    </div>

    {{-- Validation Errors --}}
    @if($errors->any())
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title">{{ __('Please fix the following errors') }}</div>
                <div class="create-alert-text">
                    <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.shipments.update', $shipment) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Basic Information Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Basic Information') }}</h5>
                            <p class="create-card-subtitle">{{ __('Update the shipment identification details') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-group">
                            <label class="create-form-label">
                                <i class="bi bi-hash"></i>
                                {{ __('Shipment Number') }}
                                <span class="create-form-required">*</span>
                            </label>
                            <div class="create-input-icon-wrapper">
                                <input type="text" 
                                       name="shipment_number" 
                                       id="shipment_number"
                                       class="create-input @error('shipment_number') is-invalid @enderror" 
                                       value="{{ old('shipment_number', $shipment->shipment_number) }}"
                                       placeholder="SH-2025-0001"
                                       required>
                                <i class="bi bi-upc-scan create-input-icon"></i>
                            </div>
                            @error('shipment_number')
                                <div class="create-form-error">
                                    <i class="bi bi-exclamation-circle"></i>
                                    {{ $message }}
                                </div>
                            @enderror
                            <p class="create-form-hint">
                                <i class="bi bi-lightbulb"></i>
                                {{ __('Enter a unique shipment number (e.g., SH-2025-0001)') }}
                            </p>
                        </div>
                    </div>
                </div>

                {{-- Vehicle & Cargo Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-truck"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Vehicle & Cargo Details') }}</h5>
                            <p class="create-card-subtitle">{{ __('Update the vehicle type and cargo information') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-truck-front"></i>
                                    {{ __('Vehicle Type') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select name="vehicle_type_id" 
                                        id="vehicle_type_id"
                                        class="create-select @error('vehicle_type_id') is-invalid @enderror"
                                        required>
                                    <option value="">{{ __('Select Vehicle Type') }}</option>
                                    @foreach($vehicleTypes as $type)
                                        <option value="{{ $type->id }}" 
                                                {{ old('vehicle_type_id', $shipment->vehicle_type_id) == $type->id ? 'selected' : '' }}>
                                            {{ $type->name }} ({{ $type->capacity }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('vehicle_type_id')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                                <p class="create-form-hint">
                                    <i class="bi bi-info-circle"></i>
                                    {{ __('This determines which vehicles can be assigned to this shipment') }}
                                </p>
                            </div>

                            <div class="create-form-group">
                                <label class="create-form-label">
                                    <i class="bi bi-box-seam"></i>
                                    {{ __('Cargo Weight (Tons)') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <div class="create-input-group">
                                    <input type="number" 
                                           name="cargo_weight"
                                           id="cargo_weight"
                                           class="create-input @error('cargo_weight') is-invalid @enderror" 
                                           value="{{ old('cargo_weight', $shipment->cargo_weight) }}"
                                           placeholder="0.00"
                                           step="0.01"
                                           min="0">
                                    <span class="create-input-addon">T</span>
                                </div>
                                @error('cargo_weight')
                                    <div class="create-form-error">
                                        <i class="bi bi-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Priority Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon warning">
                            <i class="bi bi-flag"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h5 class="create-card-title">{{ __('Priority Level') }}</h5>
                            <p class="create-card-subtitle">{{ __('Update the urgency level for this shipment') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-group">
                            <div class="create-radio-cards">
                                <div class="create-radio-card">
                                    <input type="radio" name="priority" id="priority_normal" value="normal" 
                                           {{ old('priority', $shipment->priority) == 'normal' ? 'checked' : '' }}>
                                    <label for="priority_normal" class="create-radio-card-label priority-normal">
                                        <i class="bi bi-flag"></i>
                                        {{ __('Normal') }}
                                    </label>
                                </div>
                                <div class="create-radio-card">
                                    <input type="radio" name="priority" id="priority_high" value="high"
                                           {{ old('priority', $shipment->priority) == 'high' ? 'checked' : '' }}>
                                    <label for="priority_high" class="create-radio-card-label priority-high">
                                        <i class="bi bi-flag-fill"></i>
                                        {{ __('High') }}
                                    </label>
                                </div>
                                <div class="create-radio-card">
                                    <input type="radio" name="priority" id="priority_urgent" value="urgent"
                                           {{ old('priority', $shipment->priority) == 'urgent' ? 'checked' : '' }}>
                                    <label for="priority_urgent" class="create-radio-card-label priority-urgent">
                                        <i class="bi bi-exclamation-triangle-fill"></i>
                                        {{ __('Urgent') }}
                                    </label>
                                </div>
                            </div>
                            @error('priority')
                                <div class="create-form-error">
                                    <i class="bi bi-exclamation-circle"></i>
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    {{-- Form Actions --}}
                    <div class="create-card-actions">
                        <div class="create-card-actions-left">
                            <a href="{{ route('admin.shipments.show', $shipment) }}" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-circle"></i>
                                {{ __('Cancel') }}
                            </a>
                        </div>
                        <div class="create-card-actions-right">
                            <button type="submit" class="create-btn create-btn-primary">
                                <i class="bi bi-save"></i>
                                {{ __('Update Shipment') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Current Status Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon {{ $shipment->status === 'pending' ? 'warning' : ($shipment->status === 'delivered' ? 'success' : 'info') }}">
                            <i class="bi bi-{{ $shipment->status === 'pending' ? 'clock' : ($shipment->status === 'delivered' ? 'check-circle' : 'truck') }}"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Current Status') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            <span class="create-status-badge {{ $shipment->status === 'pending' ? 'pending' : 'active' }}">
                                <i class="bi bi-{{ $shipment->status === 'pending' ? 'clock' : ($shipment->status === 'delivered' ? 'check-circle' : 'truck') }}"></i>
                                {{ __(ucfirst(str_replace('_', ' ', $shipment->status))) }}
                            </span>
                            <p class="create-status-description">
                                {{ __('Created') }}: {{ $shipment->created_at->format('d M Y, h:i A') }}
                            </p>
                        </div>
                    </div>
                </div>

                {{-- Shipment Details Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon primary">
                            <i class="bi bi-box-seam"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Shipment Details') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-hash"></i>
                                <span><strong>{{ __('ID') }}:</strong> #{{ $shipment->id }}</span>
                            </li>
                            <li>
                                <i class="bi bi-truck"></i>
                                <span><strong>{{ __('Vehicle Type') }}:</strong> {{ $shipment->vehicleType->name }}</span>
                            </li>
                            <li>
                                <i class="bi bi-person"></i>
                                <span><strong>{{ __('Created By') }}:</strong> {{ $shipment->creator->name }}</span>
                            </li>
                            @if($shipment->updated_at)
                            <li>
                                <i class="bi bi-clock-history"></i>
                                <span><strong>{{ __('Last Updated') }}:</strong> {{ $shipment->updated_at->diffForHumans() }}</span>
                            </li>
                            @endif
                        </ul>
                    </div>
                </div>

                {{-- Quick Actions Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon success">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Actions') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.shipments.show', $shipment) }}" class="create-quick-action-btn">
                                <i class="bi bi-eye"></i>
                                {{ __('View Details') }}
                            </a>
                            <a href="{{ route('admin.shipments.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Shipments') }}
                            </a>
                            @if($shipment->status === 'pending')
                            <a href="{{ route('admin.trips.create') }}?shipment_id={{ $shipment->id }}" class="create-quick-action-btn">
                                <i class="bi bi-plus-circle"></i>
                                {{ __('Assign Vehicle') }}
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection