@extends('layouts.app')

@section('title', $shipment->shipment_number . ' - ' . __('Shipment Details'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admindetailpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header with Breadcrumb --}}
    <div class="page-header">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.shipments.index') }}">{{ __('Shipments') }}</a></li>
                    <li class="breadcrumb-item active">{{ $shipment->shipment_number }}</li>
                </ol>
            </nav>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="detail-alert detail-alert-info">
            <div class="detail-alert-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title">{{ __('Success') }}</div>
                <div class="detail-alert-text">{{ session('success') }}</div>
            </div>
        </div>
    @endif

    @if(session('error'))
        <div class="detail-alert detail-alert-warning">
            <div class="detail-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="detail-alert-content">
                <div class="detail-alert-title">{{ __('Error') }}</div>
                <div class="detail-alert-text">{{ session('error') }}</div>
            </div>
        </div>
    @endif

    {{-- Hero Section --}}
    <div class="detail-hero">
        <div class="detail-hero-header">
            <div class="detail-hero-content">
                <div class="detail-hero-icon">
                    <i class="bi bi-box-seam"></i>
                </div>
                <div class="detail-hero-info">
                    <h1 class="detail-hero-title">{{ $shipment->shipment_number }}</h1>
                    <p class="detail-hero-subtitle">{{ $shipment->vehicleType->name }} · {{ __('Created') }} {{ $shipment->created_at->format('M d, Y') }}</p>
                    <div class="detail-hero-badges">
                        @php
                            $statusClasses = [
                                'pending' => 'pending',
                                'assigned' => 'assigned',
                                'in_transit' => 'in-transit',
                                'delivered' => 'delivered',
                                'cancelled' => 'cancelled'
                            ];
                            $statusIcons = [
                                'pending' => 'clock',
                                'assigned' => 'check-circle',
                                'in_transit' => 'truck',
                                'delivered' => 'check-all',
                                'cancelled' => 'x-circle'
                            ];
                            $priorityClasses = [
                                'normal' => 'normal',
                                'high' => 'high',
                                'urgent' => 'urgent'
                            ];
                            $priorityIcons = [
                                'normal' => 'flag',
                                'high' => 'flag-fill',
                                'urgent' => 'exclamation-triangle-fill'
                            ];
                        @endphp
                        <span class="status-badge status-badge-{{ $statusClasses[$shipment->status] ?? 'pending' }}">
                            <i class="bi bi-{{ $statusIcons[$shipment->status] ?? 'circle' }}"></i>
                            {{ __(ucfirst(str_replace('_', ' ', $shipment->status))) }}
                        </span>
                        <span class="priority-badge priority-badge-{{ $priorityClasses[$shipment->priority] ?? 'normal' }}">
                            <i class="bi bi-{{ $priorityIcons[$shipment->priority] ?? 'flag' }}"></i>
                            {{ __(ucfirst($shipment->priority)) }}
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <div class="detail-hero-body">
            <div class="hero-stat">
                <div class="hero-stat-value">
                    <i class="bi bi-truck text-primary"></i>
                </div>
                <div class="hero-stat-label">{{ $shipment->vehicleType->name }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">{{ $shipment->cargo_weight ? number_format($shipment->cargo_weight, 2) . ' T' : '-' }}</div>
                <div class="hero-stat-label">{{ __('Cargo Weight') }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">{{ $shipment->trips->count() }}</div>
                <div class="hero-stat-label">{{ __('Trips') }}</div>
            </div>
            <div class="hero-stat">
                <div class="hero-stat-value">{{ $shipment->vehicleType->capacity ?? '-' }}</div>
                <div class="hero-stat-label">{{ __('Vehicle Capacity') }}</div>
            </div>
        </div>
    </div>

    {{-- Status Progress for assigned/in_transit shipments --}}
    @if(in_array($shipment->status, ['assigned', 'in_transit', 'delivered']))
    <div class="detail-card">
        <div class="detail-card-body">
            <div class="progress-steps">
                <div class="progress-step completed">
                    <div class="progress-step-icon">
                        <i class="bi bi-check-lg"></i>
                    </div>
                    <div class="progress-step-label">{{ __('Created') }}</div>
                </div>
                <div class="progress-step {{ in_array($shipment->status, ['assigned', 'in_transit', 'delivered']) ? 'completed' : '' }}">
                    <div class="progress-step-icon">
                        <i class="bi bi-{{ in_array($shipment->status, ['assigned', 'in_transit', 'delivered']) ? 'check-lg' : 'clock' }}"></i>
                    </div>
                    <div class="progress-step-label">{{ __('Assigned') }}</div>
                </div>
                <div class="progress-step {{ in_array($shipment->status, ['in_transit', 'delivered']) ? 'completed' : ($shipment->status === 'assigned' ? 'active' : '') }}">
                    <div class="progress-step-icon">
                        <i class="bi bi-{{ in_array($shipment->status, ['in_transit', 'delivered']) ? 'check-lg' : 'truck' }}"></i>
                    </div>
                    <div class="progress-step-label">{{ __('In Transit') }}</div>
                </div>
                <div class="progress-step {{ $shipment->status === 'delivered' ? 'completed' : ($shipment->status === 'in_transit' ? 'active' : '') }}">
                    <div class="progress-step-icon">
                        <i class="bi bi-{{ $shipment->status === 'delivered' ? 'check-lg' : 'box-arrow-in-down' }}"></i>
                    </div>
                    <div class="progress-step-label">{{ __('Delivered') }}</div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <div class="row">
        {{-- Main Content --}}
        <div class="col-lg-8">
            {{-- Shipment Information Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon primary">
                        <i class="bi bi-info-circle"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Shipment Information') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Shipment Number') }}</span>
                            <span class="info-item-value highlight">{{ $shipment->shipment_number }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Vehicle Type') }}</span>
                            <span class="info-item-value">{{ $shipment->vehicleType->name }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Vehicle Capacity') }}</span>
                            <span class="info-item-value">{{ $shipment->vehicleType->capacity ?? '-' }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Cargo Weight') }}</span>
                            <span class="info-item-value">{{ $shipment->cargo_weight ? number_format($shipment->cargo_weight, 2) . ' T' : '-' }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Priority') }}</span>
                            <span class="priority-badge priority-badge-{{ $priorityClasses[$shipment->priority] ?? 'normal' }}">
                                <i class="bi bi-{{ $priorityIcons[$shipment->priority] ?? 'flag' }}"></i>
                                {{ __(ucfirst($shipment->priority)) }}
                            </span>
                        </div>
                        <div class="info-item">
                            <span class="info-item-label">{{ __('Status') }}</span>
                            <span class="status-badge status-badge-{{ $statusClasses[$shipment->status] ?? 'pending' }}">
                                <i class="bi bi-{{ $statusIcons[$shipment->status] ?? 'circle' }}"></i>
                                {{ __(ucfirst(str_replace('_', ' ', $shipment->status))) }}
                            </span>
                        </div>
                    </div>
                </div>
                
                {{-- Action Buttons --}}
                @if($shipment->status === 'pending')
                <div class="detail-actions">
                    <a href="{{ route('admin.shipments.assign-vehicle', $shipment) }}" class="btn-detail btn-detail-success">
                        <i class="bi bi-truck"></i>
                        {{ __('Assign Vehicle & Driver') }}
                    </a>
                    <a href="{{ route('admin.shipments.edit', $shipment) }}" class="btn-detail btn-detail-warning">
                        <i class="bi bi-pencil"></i>
                        {{ __('Edit Shipment') }}
                    </a>
                    <form action="{{ route('admin.shipments.cancel', $shipment) }}" method="POST" class="d-inline" onsubmit="return confirm('{{ __('Are you sure you want to cancel this shipment?') }}')">
                        @csrf
                        @method('PATCH')
                        <button type="submit" class="btn-detail btn-detail-danger">
                            <i class="bi bi-x-circle"></i>
                            {{ __('Cancel Shipment') }}
                        </button>
                    </form>
                    <a href="{{ route('admin.shipments.index') }}" class="btn-detail btn-detail-outline">
                        <i class="bi bi-arrow-left"></i>
                        {{ __('Back to List') }}
                    </a>
                </div>
                @else
                <div class="detail-actions">
                    <a href="{{ route('admin.shipments.index') }}" class="btn-detail btn-detail-outline">
                        <i class="bi bi-arrow-left"></i>
                        {{ __('Back to List') }}
                    </a>
                </div>
                @endif
            </div>

            {{-- Associated Trips Card --}}
            @if($shipment->trips->count() > 0)
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon info">
                        <i class="bi bi-geo-alt"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Associated Trips') }} ({{ $shipment->trips->count() }})</h5>
                </div>
                <div class="detail-card-body-compact">
                    <div class="table-responsive">
                        <table class="related-items-table">
                            <thead>
                                <tr>
                                    <th>{{ __('Trip Number') }}</th>
                                    <th>{{ __('Vehicle') }}</th>
                                    <th>{{ __('Driver') }}</th>
                                    <th>{{ __('Pickup Location') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($shipment->trips as $trip)
                                <tr>
                                    <td>
                                        <a href="{{ route('admin.trips.show', $trip) }}" class="item-link">
                                            {{ $trip->trip_number }}
                                        </a>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <span class="badge bg-light text-dark">
                                                <i class="bi bi-truck me-1"></i>
                                                {{ $trip->vehicle->vehicle_number }}
                                            </span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <i class="bi bi-person-circle text-muted"></i>
                                            {{ $trip->driver->name }}
                                        </div>
                                    </td>
                                    <td>
                                        <span title="{{ $trip->pickup_location }}">
                                            {{ Str::limit($trip->pickup_location, 25) }}
                                        </span>
                                    </td>
                                    <td>
                                        @php
                                            $tripStatusClass = $statusClasses[$trip->status] ?? 'pending';
                                            $tripStatusIcon = $statusIcons[$trip->status] ?? 'circle';
                                        @endphp
                                        <span class="status-badge status-badge-{{ $tripStatusClass }}" style="font-size: 0.75rem; padding: 0.3rem 0.7rem;">
                                            <i class="bi bi-{{ $tripStatusIcon }}" style="font-size: 0.8rem;"></i>
                                            {{ __(ucfirst(str_replace('_', ' ', $trip->status))) }}
                                        </span>
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.trips.show', $trip) }}" class="btn-detail btn-detail-primary" style="padding: 0.4rem 0.75rem; font-size: 0.8rem;">
                                            <i class="bi bi-eye"></i>
                                            {{ __('View') }}
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            @endif
        </div>

        {{-- Sidebar --}}
        <div class="col-lg-4">
            {{-- Available Vehicles Preview (for pending shipments) --}}
            @if($shipment->status === 'pending')
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon success">
                        <i class="bi bi-truck-front"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Available Vehicles') }}</h5>
                </div>
                <div class="detail-card-body">
                    @if($availableVehicles->count() > 0)
                        <div class="d-flex align-items-center justify-content-between mb-3">
                            <span class="info-item-value large text-success">{{ $availableVehicles->count() }}</span>
                            <span class="info-item-label">{{ __('vehicles available') }}</span>
                        </div>
                        <p class="text-muted small mb-3">
                            {{ __('Vehicles matching') }} <strong>{{ $shipment->vehicleType->name }}</strong> {{ __('type are ready for assignment.') }}
                        </p>
                        <a href="{{ route('admin.shipments.assign-vehicle', $shipment) }}" class="btn-detail btn-detail-success w-100 justify-content-center">
                            <i class="bi bi-plus-circle"></i>
                            {{ __('Assign Vehicle') }}
                        </a>
                    @else
                        <div class="detail-empty-state">
                            <div class="detail-empty-state-icon">
                                <i class="bi bi-truck"></i>
                            </div>
                            <h6 class="detail-empty-state-title">{{ __('No Vehicles Available') }}</h6>
                            <p class="detail-empty-state-text">{{ __('No vehicles of type') }} <strong>{{ $shipment->vehicleType->name }}</strong> {{ __('are currently available.') }}</p>
                        </div>
                    @endif
                </div>
            </div>
            @endif

            {{-- Creator & Timeline Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon secondary">
                        <i class="bi bi-clock-history"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Activity') }}</h5>
                </div>
                <div class="detail-card-body">
                    {{-- Creator Info --}}
                    <div class="entity-card mb-3">
                        <div class="entity-card-avatar info">
                            <i class="bi bi-person"></i>
                        </div>
                        <div class="entity-card-content">
                            <h6 class="entity-card-title">{{ $shipment->creator->name }}</h6>
                            <p class="entity-card-subtitle">{{ __('Created By') }}</p>
                        </div>
                    </div>

                    {{-- Timeline --}}
                    <div class="detail-timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker primary">
                                <i class="bi bi-plus"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">{{ __('Shipment Created') }}</h6>
                                <p class="timeline-time">{{ $shipment->created_at->format('M d, Y \a\t h:i A') }}</p>
                            </div>
                        </div>
                        
                        @if($shipment->status !== 'pending')
                        <div class="timeline-item">
                            <div class="timeline-marker info">
                                <i class="bi bi-check"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">{{ __('Status Updated') }}</h6>
                                <p class="timeline-time">{{ __('Changed to') }} {{ __(ucfirst(str_replace('_', ' ', $shipment->status))) }}</p>
                            </div>
                        </div>
                        @endif

                        <div class="timeline-item">
                            <div class="timeline-marker secondary">
                                <i class="bi bi-pencil"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">{{ __('Last Updated') }}</h6>
                                <p class="timeline-time">{{ $shipment->updated_at->format('M d, Y \a\t h:i A') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Quick Stats Card --}}
            <div class="detail-card">
                <div class="detail-card-header">
                    <div class="detail-card-header-icon warning">
                        <i class="bi bi-bar-chart"></i>
                    </div>
                    <h5 class="detail-card-title">{{ __('Quick Stats') }}</h5>
                </div>
                <div class="detail-card-body">
                    <div class="data-list">
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-truck"></i>
                                {{ __('Vehicle Type') }}
                            </span>
                            <span class="data-list-item-value">{{ $shipment->vehicleType->name }}</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-box"></i>
                                {{ __('Cargo Weight') }}
                            </span>
                            <span class="data-list-item-value">{{ $shipment->cargo_weight ? number_format($shipment->cargo_weight, 2) . ' T' : '-' }}</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-geo-alt"></i>
                                {{ __('Total Trips') }}
                            </span>
                            <span class="data-list-item-value">{{ $shipment->trips->count() }}</span>
                        </div>
                        <div class="data-list-item">
                            <span class="data-list-item-label">
                                <i class="bi bi-calendar"></i>
                                {{ __('Days Since Created') }}
                            </span>
                            <span class="data-list-item-value">{{ $shipment->created_at->diffInDays(now()) }} {{ __('days') }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection