@extends('layouts.app')

@section('title', __('add_user') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
<style>
    /* Role Card Styles */
    .role-cards-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 1rem;
    }

    .role-card {
        background: var(--body-bg);
        border: 2px solid var(--border-color);
        border-radius: 12px;
        padding: 1rem;
        transition: all 0.2s ease;
        cursor: pointer;
    }

    .role-card:hover {
        border-color: var(--primary-color);
        background: var(--card-bg);
    }

    .role-card.selected {
        border-color: var(--primary-color);
        background: rgba(249, 115, 22, 0.05);
    }

    .role-card-header {
        display: flex;
        align-items: flex-start;
        gap: 0.75rem;
    }

    .role-card-checkbox {
        margin-top: 0.25rem;
    }

    .role-card-checkbox input[type="checkbox"] {
        width: 1.25rem;
        height: 1.25rem;
        cursor: pointer;
    }

    .role-card-content {
        flex: 1;
    }

    .role-card-name {
        font-weight: 600;
        color: var(--text-primary);
        margin-bottom: 0.25rem;
    }

    .role-card-description {
        font-size: 0.85rem;
        color: var(--text-secondary);
        margin: 0;
    }

    .role-card-icon {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        background: var(--primary-light);
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--primary-color);
    }
</style>
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <nav class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.users.index') }}">{{ __('users') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('add_user') }}</span>
            </nav>
            <h1 class="create-page-title">
                <span class="create-page-title-icon">
                    <i class="bi bi-person-plus"></i>
                </span>
                {{ __('add_user') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Create a new user account') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.users.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('back') }}
            </a>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <form action="{{ route('admin.users.store') }}" method="POST">
        @csrf

        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- User Information --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon primary">
                            <i class="bi bi-person"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">{{ __('user_information') }}</h3>
                            <p class="create-card-subtitle">{{ __('Basic user details') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="name" class="create-form-label">
                                    {{ __('name') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="text" 
                                       class="create-input @error('name') is-invalid @enderror" 
                                       id="name" 
                                       name="name" 
                                       value="{{ old('name') }}" 
                                       placeholder="{{ __('enter_full_name') }}" 
                                       required>
                                @error('name')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="email" class="create-form-label">
                                    {{ __('email') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="email" 
                                       class="create-input @error('email') is-invalid @enderror" 
                                       id="email" 
                                       name="email" 
                                       value="{{ old('email') }}" 
                                       placeholder="user@example.com" 
                                       required>
                                @error('email')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="mobile" class="create-form-label">
                                    {{ __('mobile') }}
                                    <span class="create-form-optional">({{ __('Optional') }})</span>
                                </label>
                                <input type="text" 
                                       class="create-input @error('mobile') is-invalid @enderror" 
                                       id="mobile" 
                                       name="mobile" 
                                       value="{{ old('mobile') }}" 
                                       placeholder="+1234567890">
                                @error('mobile')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="status" class="create-form-label">
                                    {{ __('status') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <select class="create-select @error('status') is-invalid @enderror" 
                                        id="status" 
                                        name="status" 
                                        required>
                                    <option value="active" {{ old('status') === 'active' ? 'selected' : '' }}>
                                        {{ __('active') }}
                                    </option>
                                    <option value="inactive" {{ old('status') === 'inactive' ? 'selected' : '' }}>
                                        {{ __('inactive') }}
                                    </option>
                                </select>
                                @error('status')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Password Section --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon info">
                            <i class="bi bi-lock"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">{{ __('set_password') }}</h3>
                            <p class="create-card-subtitle">{{ __('Set login credentials') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="password" class="create-form-label">
                                    {{ __('password') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="password" 
                                       class="create-input @error('password') is-invalid @enderror" 
                                       id="password" 
                                       name="password" 
                                       placeholder="{{ __('minimum_6_characters') }}" 
                                       required>
                                @error('password')
                                    <span class="create-form-error">{{ $message }}</span>
                                @enderror
                                <span class="create-form-hint">{{ __('Minimum 6 characters') }}</span>
                            </div>
                            <div class="create-form-group">
                                <label for="password_confirmation" class="create-form-label">
                                    {{ __('confirm_password') }}
                                    <span class="create-form-required">*</span>
                                </label>
                                <input type="password" 
                                       class="create-input" 
                                       id="password_confirmation" 
                                       name="password_confirmation" 
                                       placeholder="{{ __('re_enter_password') }}" 
                                       required>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Roles Section --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-header-icon success">
                            <i class="bi bi-shield-lock"></i>
                        </div>
                        <div class="create-card-header-content">
                            <h3 class="create-card-title">
                                {{ __('assign_roles') }}
                                <span class="create-form-required">*</span>
                            </h3>
                            <p class="create-card-subtitle">{{ __('Select user roles and permissions') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        @error('roles')
                            <div class="alert alert-danger mb-3">
                                <i class="bi bi-exclamation-triangle me-2"></i>{{ $message }}
                            </div>
                        @enderror

                        <div class="role-cards-grid">
                            @foreach($roles as $role)
                            <label class="role-card" for="role_{{ $role->id }}">
                                <div class="role-card-header">
                                    <div class="role-card-checkbox">
                                        <input class="form-check-input" 
                                               type="checkbox" 
                                               name="roles[]" 
                                               value="{{ $role->id }}" 
                                               id="role_{{ $role->id }}"
                                               {{ in_array($role->id, old('roles', [])) ? 'checked' : '' }}>
                                    </div>
                                    <div class="role-card-content">
                                        <div class="role-card-name">{{ $role->display_name }}</div>
                                        @if($role->description)
                                            <p class="role-card-description">{{ $role->description }}</p>
                                        @endif
                                    </div>
                                    <div class="role-card-icon">
                                        <i class="bi bi-shield-check"></i>
                                    </div>
                                </div>
                            </label>
                            @endforeach
                        </div>
                    </div>

                    {{-- Form Actions --}}
                    <div class="create-card-actions">
                        <div class="create-card-actions-left">
                            <a href="{{ route('admin.users.index') }}" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-lg"></i>
                                {{ __('cancel') }}
                            </a>
                        </div>
                        <div class="create-card-actions-right">
                            <button type="submit" class="create-btn create-btn-primary">
                                <i class="bi bi-check-lg"></i>
                                {{ __('save') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Quick Tips --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-lightbulb"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Quick Tips') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Email must be unique in the system') }}
                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Password should be at least 6 characters') }}
                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Assign at least one role to the user') }}
                            </li>
                            <li>
                                <i class="bi bi-check-circle text-success"></i>
                                {{ __('Active users can login to the system') }}
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Status Info --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Status Info') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-preview">
                            <span class="create-status-badge" style="background-color: rgba(25, 135, 84, 0.1); color: #198754;">
                                <i class="bi bi-check-circle"></i>
                                {{ __('active') }}
                            </span>
                            <p class="create-status-description">{{ __('User can login and access the system') }}</p>
                        </div>
                        <div class="create-status-preview">
                            <span class="create-status-badge" style="background-color: rgba(108, 117, 125, 0.1); color: #6c757d;">
                                <i class="bi bi-x-circle"></i>
                                {{ __('inactive') }}
                            </span>
                            <p class="create-status-description">{{ __('User is disabled and cannot login') }}</p>
                        </div>
                    </div>
                </div>

                {{-- Quick Actions --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h4 class="create-sidebar-title">{{ __('Quick Actions') }}</h4>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.users.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Users') }}
                            </a>
                            <a href="{{ route('admin.roles.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-shield-lock"></i>
                                {{ __('Manage Roles') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add selected class to role cards when checkbox is checked
    document.querySelectorAll('.role-card input[type="checkbox"]').forEach(function(checkbox) {
        // Initial state
        if (checkbox.checked) {
            checkbox.closest('.role-card').classList.add('selected');
        }
        
        // On change
        checkbox.addEventListener('change', function() {
            if (this.checked) {
                this.closest('.role-card').classList.add('selected');
            } else {
                this.closest('.role-card').classList.remove('selected');
            }
        });
    });
});
</script>
@endpush