@extends('layouts.app')

@section('title', __('add_vehicle_type') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/admincreatepage.css') }}">
@endpush

@section('content')
<div class="create-page-container">
    {{-- Page Header --}}
    <div class="create-page-header">
        <div class="create-page-header-content">
            <div class="create-page-breadcrumb">
                <a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
                <i class="bi bi-chevron-right"></i>
                <a href="{{ route('admin.vehicle-types.index') }}">{{ __('vehicle_types') }}</a>
                <i class="bi bi-chevron-right"></i>
                <span>{{ __('Create') }}</span>
            </div>
            <h1 class="create-page-title">
                <div class="create-page-title-icon">
                    <i class="bi bi-plus-lg"></i>
                </div>
                {{ __('add_vehicle_type') }}
            </h1>
            <p class="create-page-subtitle">{{ __('Define a new vehicle category for your fleet') }}</p>
        </div>
        <div class="create-page-actions">
            <a href="{{ route('admin.vehicle-types.index') }}" class="create-btn create-btn-secondary">
                <i class="bi bi-arrow-left"></i>
                {{ __('cancel') }}
            </a>
        </div>
    </div>

    {{-- Validation Errors --}}
    @if($errors->any())
        <div class="create-alert danger">
            <div class="create-alert-icon">
                <i class="bi bi-exclamation-triangle"></i>
            </div>
            <div class="create-alert-content">
                <div class="create-alert-title">{{ __('Validation Error') }}</div>
                <div class="create-alert-text">{{ __('Please check the form and fix the errors below.') }}</div>
            </div>
        </div>
    @endif

    <form action="{{ route('admin.vehicle-types.store') }}" method="POST">
        @csrf
        <div class="create-form-layout">
            {{-- Main Form --}}
            <div class="create-form-main">
                {{-- Basic Information Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon primary">
                            <i class="bi bi-tags"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('Basic Information') }}</h5>
                            <p class="create-card-subtitle">{{ __('Enter the vehicle type details') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="name" class="create-label required">{{ __('name') }}</label>
                                <input type="text" 
                                       class="create-input @error('name') is-invalid @enderror" 
                                       id="name" 
                                       name="name" 
                                       value="{{ old('name') }}"
                                       placeholder="{{ __('e.g., Heavy Truck, Light Van') }}"
                                       required>
                                @error('name')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="capacity" class="create-label required">{{ __('capacity') }}</label>
                                <input type="text" 
                                       class="create-input @error('capacity') is-invalid @enderror" 
                                       id="capacity" 
                                       name="capacity" 
                                       value="{{ old('capacity') }}"
                                       placeholder="e.g., 10 Tons"
                                       required>
                                @error('capacity')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Pricing & Status Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon success">
                            <i class="bi bi-currency-dollar"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('Pricing & Status') }}</h5>
                            <p class="create-card-subtitle">{{ __('Set the base price and availability') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-row">
                            <div class="create-form-group">
                                <label for="base_price" class="create-label required">{{ __('base_price') }} ($)</label>
                                <input type="number" 
                                       class="create-input @error('base_price') is-invalid @enderror" 
                                       id="base_price" 
                                       name="base_price" 
                                       value="{{ old('base_price') }}"
                                       step="0.01" 
                                       min="0"
                                       placeholder="0.00"
                                       required>
                                @error('base_price')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="create-form-group">
                                <label for="status" class="create-label required">{{ __('status') }}</label>
                                <select class="create-select @error('status') is-invalid @enderror" 
                                        id="status" name="status" required>
                                    <option value="active" {{ old('status') === 'active' ? 'selected' : '' }}>
                                        {{ __('active') }}
                                    </option>
                                    <option value="inactive" {{ old('status') === 'inactive' ? 'selected' : '' }}>
                                        {{ __('inactive') }}
                                    </option>
                                </select>
                                @error('status')
                                    <div class="create-error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Description Card --}}
                <div class="create-card">
                    <div class="create-card-header">
                        <div class="create-card-icon warning">
                            <i class="bi bi-card-text"></i>
                        </div>
                        <div>
                            <h5 class="create-card-title">{{ __('description') }}</h5>
                            <p class="create-card-subtitle">{{ __('Optional details about this vehicle type') }}</p>
                        </div>
                    </div>
                    <div class="create-card-body">
                        <div class="create-form-group">
                            <label for="description" class="create-label">{{ __('description') }}</label>
                            <textarea class="create-textarea @error('description') is-invalid @enderror" 
                                      id="description" 
                                      name="description" 
                                      rows="3"
                                      placeholder="{{ __('Describe the vehicle type characteristics, use cases, etc.') }}">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="create-error">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Form Actions --}}
                <div class="create-card">
                    <div class="create-card-body">
                        <div class="create-form-actions">
                            <a href="{{ route('admin.vehicle-types.index') }}" class="create-btn create-btn-secondary">
                                <i class="bi bi-x-lg"></i>
                                {{ __('cancel') }}
                            </a>
                            <button type="submit" class="create-btn create-btn-primary">
                                <i class="bi bi-check-circle"></i>
                                {{ __('save') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Sidebar --}}
            <div class="create-form-sidebar">
                {{-- Tips Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon info">
                            <i class="bi bi-lightbulb"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Tips') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <ul class="create-tips-list">
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Use descriptive names for easy identification') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Include unit in capacity (e.g., Tons, Kg)') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Base price is used for trip cost calculations') }}</span>
                            </li>
                            <li>
                                <i class="bi bi-check-circle-fill"></i>
                                <span>{{ __('Inactive types won\'t appear in vehicle creation') }}</span>
                            </li>
                        </ul>
                    </div>
                </div>

                {{-- Status Guide Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon warning">
                            <i class="bi bi-info-circle"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Status Guide') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-status-guide">
                            <div class="create-status-item">
                                <span class="create-status-badge active">
                                    <i class="bi bi-check-circle"></i>
                                    {{ __('active') }}
                                </span>
                                <p>{{ __('Available for new vehicles') }}</p>
                            </div>
                            <div class="create-status-item">
                                <span class="create-status-badge danger">
                                    <i class="bi bi-x-circle"></i>
                                    {{ __('inactive') }}
                                </span>
                                <p>{{ __('Hidden from selection') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Quick Actions Card --}}
                <div class="create-sidebar-card">
                    <div class="create-sidebar-header">
                        <div class="create-sidebar-icon success">
                            <i class="bi bi-lightning"></i>
                        </div>
                        <h5 class="create-sidebar-title">{{ __('Quick Actions') }}</h5>
                    </div>
                    <div class="create-sidebar-body">
                        <div class="create-quick-actions">
                            <a href="{{ route('admin.vehicle-types.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-list-ul"></i>
                                {{ __('View All Types') }}
                            </a>
                            <a href="{{ route('admin.vehicles.index') }}" class="create-quick-action-btn">
                                <i class="bi bi-truck"></i>
                                {{ __('Manage Vehicles') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection