@extends('layouts.app')

@section('title', __('vehicles') . ' - ' . __('app_name'))

@push('styles')
<link rel="stylesheet" href="{{ asset('css/adminlistpage.css') }}">
@endpush

@section('content')
<div class="container-fluid">
    {{-- Page Header --}}
    <div class="list-page-header">
        <div class="list-page-header-left">
            <h1 class="list-page-title">
                <i class="bi bi-truck"></i>
                {{ __('vehicles') }}
            </h1>
            <p class="list-page-subtitle">{{ __('Manage and track all your fleet vehicles') }}</p>
        </div>
        <div class="list-page-header-actions">
            <a href="{{ route('admin.vehicles.create') }}" class="btn-create">
                <i class="bi bi-plus-lg"></i>
                {{ __('add_vehicle') }}
            </a>
        </div>
    </div>

    {{-- Flash Messages --}}
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show mb-3" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Stats Bar --}}
    <div class="list-stats-bar">
        <div class="list-stat-card gradient-purple">
            <div class="list-stat-icon">
                <i class="bi bi-truck"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $vehicles->total() }}</div>
                <div class="list-stat-label">{{ __('Total Vehicles') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-box-seam"></i>
                {{ __('Fleet Size') }}
            </div>
        </div>

        <div class="list-stat-card gradient-green">
            <div class="list-stat-icon">
                <i class="bi bi-check-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $vehicles->where('status', 'active')->count() }}</div>
                <div class="list-stat-label">{{ __('active') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-play-circle"></i>
                {{ __('Ready to Use') }}
            </div>
        </div>

        <div class="list-stat-card gradient-orange">
            <div class="list-stat-icon">
                <i class="bi bi-tools"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $vehicles->where('status', 'maintenance')->count() }}</div>
                <div class="list-stat-label">{{ __('maintenance') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-wrench"></i>
                {{ __('Under Service') }}
            </div>
        </div>

        <div class="list-stat-card gradient-red">
            <div class="list-stat-icon">
                <i class="bi bi-x-circle"></i>
            </div>
            <div class="list-stat-content">
                <div class="list-stat-value">{{ $vehicles->where('status', 'inactive')->count() }}</div>
                <div class="list-stat-label">{{ __('inactive') }}</div>
            </div>
            <div class="list-stat-footer">
                <i class="bi bi-pause-circle"></i>
                {{ __('Not Available') }}
            </div>
        </div>
    </div>

    {{-- Filter Bar --}}
    <div class="list-filter-bar">
        <div class="list-filter-header">
            <div class="list-filter-title">
                <i class="bi bi-funnel"></i>
                {{ __('Filters') }}
            </div>
            @if(request()->hasAny(['search', 'status']))
                <a href="{{ route('admin.vehicles.index') }}" class="list-filter-clear">
                    <i class="bi bi-x-circle"></i>
                    {{ __('Clear Filters') }}
                </a>
            @endif
        </div>
        <form action="{{ route('admin.vehicles.index') }}" method="GET">
            <div class="list-filter-row">
                <div class="list-filter-group search-group">
                    <label>{{ __('search') }}</label>
                    <div class="list-search-box">
                        <i class="bi bi-search"></i>
                        <input type="text" name="search" class="form-control" 
                               placeholder="{{ __('Search vehicle number...') }}"
                               value="{{ request('search') }}">
                    </div>
                </div>
                <div class="list-filter-group">
                    <label>{{ __('status') }}</label>
                    <select name="status" class="form-select">
                        <option value="">{{ __('All Statuses') }}</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>{{ __('active') }}</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>{{ __('inactive') }}</option>
                        <option value="maintenance" {{ request('status') === 'maintenance' ? 'selected' : '' }}>{{ __('maintenance') }}</option>
                    </select>
                </div>
                <div class="list-filter-group">
                    <label>&nbsp;</label>
                    <button type="submit" class="btn-filter">
                        <i class="bi bi-funnel"></i>
                        {{ __('Filter') }}
                    </button>
                </div>
            </div>
        </form>
    </div>

    {{-- Data Table --}}
    <div class="list-table-container">
        <div class="list-table-header">
            <h5 class="list-table-title">
                <i class="bi bi-table"></i>
                {{ __('Vehicle List') }}
                <span class="list-table-count">({{ $vehicles->total() }} {{ __('records') }})</span>
            </h5>
        </div>

        @php
            $statusClasses = [
                'active' => 'delivered',
                'inactive' => 'cancelled',
                'maintenance' => 'pending'
            ];
            $statusIcons = [
                'active' => 'check-circle',
                'inactive' => 'x-circle',
                'maintenance' => 'tools'
            ];
        @endphp

        <table class="list-table">
            <thead>
                <tr>
                    <th>{{ __('vehicle_number') }}</th>
                    <th>{{ __('vehicle_type') }}</th>
                    <th>{{ __('capacity') }}</th>
                    <th>{{ __('registration_date') }}</th>
                    <th>{{ __('insurance_expiry') }}</th>
                    <th>{{ __('status') }}</th>
                    <th>{{ __('actions') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($vehicles as $vehicle)
                <tr>
                    <td>
                        <span class="table-cell-id">{{ $vehicle->vehicle_number }}</span>
                    </td>
                    <td>
                        <div class="table-cell-main">
                            <i class="bi bi-truck text-primary me-1"></i>
                            <strong>{{ $vehicle->vehicleType->name }}</strong>
                        </div>
                    </td>
                    <td>
                        <span class="table-cell-capacity">
                            <i class="bi bi-box"></i>
                            {{ $vehicle->vehicleType->capacity }}
                        </span>
                    </td>
                    <td class="table-cell-date">
                        @if($vehicle->registration_date)
                            <i class="bi bi-calendar"></i>
                            {{ $vehicle->registration_date->format('d M Y') }}
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </td>
                    <td>
                        @if($vehicle->insurance_expiry)
                            @if($vehicle->insurance_expiry->isPast())
                                <span class="table-badge table-badge-danger">
                                    <i class="bi bi-exclamation-triangle"></i>
                                    {{ $vehicle->insurance_expiry->format('d M Y') }}
                                </span>
                            @elseif($vehicle->insurance_expiry->diffInDays(now()) <= 30)
                                <span class="table-badge table-badge-warning">
                                    <i class="bi bi-clock"></i>
                                    {{ $vehicle->insurance_expiry->format('d M Y') }}
                                </span>
                            @else
                                <span class="table-cell-date">
                                    <i class="bi bi-shield-check"></i>
                                    {{ $vehicle->insurance_expiry->format('d M Y') }}
                                </span>
                            @endif
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </td>
                    <td>
                        <span class="table-badge table-badge-{{ $statusClasses[$vehicle->status] ?? 'pending' }}">
                            <i class="bi bi-{{ $statusIcons[$vehicle->status] ?? 'circle' }}"></i>
                            {{ __(ucfirst($vehicle->status)) }}
                        </span>
                    </td>
                    <td>
                        <div class="table-actions">
                            <a href="{{ route('admin.vehicles.edit', $vehicle) }}" 
                               class="btn-table-action btn-table-edit" 
                               title="{{ __('edit') }}">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <form action="{{ route('admin.vehicles.destroy', $vehicle) }}" 
                                  method="POST" 
                                  class="d-inline"
                                  onsubmit="return confirm('{{ __('Are you sure you want to delete this vehicle?') }}')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" 
                                        class="btn-table-action btn-table-delete" 
                                        title="{{ __('delete') }}">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7">
                        <div class="list-empty-state">
                            <div class="list-empty-state-icon">
                                <i class="bi bi-truck"></i>
                            </div>
                            <h5 class="list-empty-state-title">{{ __('No Vehicles Found') }}</h5>
                            <p class="list-empty-state-text">{{ __('There are no vehicles matching your criteria. Add a new vehicle to get started.') }}</p>
                            <a href="{{ route('admin.vehicles.create') }}" class="btn-create">
                                <i class="bi bi-plus-lg"></i>
                                {{ __('add_vehicle') }}
                            </a>
                        </div>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>

        {{-- Pagination --}}
        @if($vehicles->hasPages())
        <div class="list-pagination">
            <div class="list-pagination-info">
                {{ __('Showing') }} {{ $vehicles->firstItem() }} {{ __('to') }} {{ $vehicles->lastItem() }} {{ __('of') }} {{ $vehicles->total() }} {{ __('entries') }}
            </div>
            <div class="list-pagination-nav">
                {{ $vehicles->links() }}
            </div>
        </div>
        @endif
    </div>
</div>
@endsection