<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', __('app_name'))</title>
    
    <!-- Bootstrap 5.3 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    
    <!-- Poppins Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="{{ asset('css/custom.css') }}">
    
    @stack('styles')
</head>
<body>
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <!-- Sidebar Header / Brand -->
        <div class="sidebar-header">
            <div class="sidebar-brand">
                <div class="brand-icon">
                    <i class="bi bi-truck"></i>
                </div>
                <div class="brand-text">
                    <span class="brand-name">LogiFleet</span>
                    <span class="brand-subtitle">Admin Dashboard</span>
                </div>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="sidebar-nav">
            <!-- Main Navigation Section -->
            <div class="nav-section">
                <span class="nav-section-title">{{ __('Main Navigation') }}</span>
                <ul class="nav-menu">
                    <li class="nav-item">
                        <a href="{{ route('admin.dashboard') }}" class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                            <i class="bi bi-grid-1x2-fill"></i>
                            <span>{{ __('dashboard') }}</span>
                        </a>
                    </li>

                    @if(auth()->check() && auth()->user()->hasPermission('shipments.view'))
                    <li class="nav-item has-submenu">
                        <a href="#shipmentSubmenu" class="nav-link {{ request()->routeIs('admin.shipments.*') ? 'active' : '' }}" data-bs-toggle="collapse" aria-expanded="{{ request()->routeIs('admin.shipments.*') ? 'true' : 'false' }}">
                            <i class="bi bi-box-seam-fill"></i>
                            <span>{{ __('shipments') }}</span>
                            <i class="bi bi-chevron-down submenu-arrow"></i>
                        </a>
                        <ul class="submenu collapse {{ request()->routeIs('admin.shipments.*') ? 'show' : '' }}" id="shipmentSubmenu">
                            <li>
                                <a href="{{ route('admin.shipments.index') }}" class="{{ request()->routeIs('admin.shipments.index') ? 'active' : '' }}">
                                    <span>{{ __('All Shipments') }}</span>
                                </a>
                            </li>
                            @if(auth()->user()->hasPermission('shipments.create'))
                            <li>
                                <a href="{{ route('admin.shipments.create') }}" class="{{ request()->routeIs('admin.shipments.create') ? 'active' : '' }}">
                                    <span>{{ __('New Shipment') }}</span>
                                </a>
                            </li>
                            @endif
                        </ul>
                    </li>
                    @endif

                    @if(auth()->check() && auth()->user()->hasPermission('trips.view'))
                    <li class="nav-item has-submenu">
                        <a href="#tripSubmenu" class="nav-link {{ request()->routeIs('admin.trips.*') ? 'active' : '' }}" data-bs-toggle="collapse" aria-expanded="{{ request()->routeIs('admin.trips.*') ? 'true' : 'false' }}">
                            <i class="bi bi-signpost-split-fill"></i>
                            <span>{{ __('trips') }}</span>
                            <i class="bi bi-chevron-down submenu-arrow"></i>
                        </a>
                        <ul class="submenu collapse {{ request()->routeIs('admin.trips.*') ? 'show' : '' }}" id="tripSubmenu">
                            <li>
                                <a href="{{ route('admin.trips.index') }}" class="{{ request()->routeIs('admin.trips.index') ? 'active' : '' }}">
                                    <span>{{ __('All Trips') }}</span>
                                </a>
                            </li>
                            @if(auth()->user()->hasPermission('trips.create'))
                            <li>
                                <a href="{{ route('admin.trips.create') }}" class="{{ request()->routeIs('admin.trips.create') ? 'active' : '' }}">
                                    <span>{{ __('New Trip') }}</span>
                                </a>
                            </li>
                            @endif
                        </ul>
                    </li>
                    @endif

                    @if(auth()->check() && auth()->user()->hasPermission('deliveries.view'))
                    <li class="nav-item">
                        <a href="{{ route('admin.deliveries.index') }}" class="nav-link {{ request()->routeIs('admin.deliveries.*') ? 'active' : '' }}">
                            <i class="bi bi-clipboard-check-fill"></i>
                            <span>{{ __('deliveries') }}</span>
                        </a>
                    </li>
                    @endif
                </ul>
            </div>

            <!-- Management Section -->
            <div class="nav-section">
                <span class="nav-section-title">{{ __('Management') }}</span>
                <ul class="nav-menu">
                    @if(auth()->check() && auth()->user()->hasPermission('vehicles.view'))
                    <li class="nav-item has-submenu">
                        <a href="#vehicleSubmenu" class="nav-link {{ request()->routeIs('admin.vehicles.*') || request()->routeIs('admin.vehicle-types.*') ? 'active' : '' }}" data-bs-toggle="collapse" aria-expanded="{{ request()->routeIs('admin.vehicles.*') || request()->routeIs('admin.vehicle-types.*') ? 'true' : 'false' }}">
                            <i class="bi bi-truck-front-fill"></i>
                            <span>{{ __('vehicles') }}</span>
                            <i class="bi bi-chevron-down submenu-arrow"></i>
                        </a>
                        <ul class="submenu collapse {{ request()->routeIs('admin.vehicles.*') || request()->routeIs('admin.vehicle-types.*') ? 'show' : '' }}" id="vehicleSubmenu">
                            <li>
                                <a href="{{ route('admin.vehicles.index') }}" class="{{ request()->routeIs('admin.vehicles.index') ? 'active' : '' }}">
                                    <span>{{ __('All Vehicles') }}</span>
                                </a>
                            </li>
                            @if(auth()->check() && auth()->user()->hasPermission('vehicle_types.view'))
                            <li>
                                <a href="{{ route('admin.vehicle-types.index') }}" class="{{ request()->routeIs('admin.vehicle-types.*') ? 'active' : '' }}">
                                    <span>{{ __('vehicle_types') }}</span>
                                </a>
                            </li>
                            @endif
                        </ul>
                    </li>
                    @endif

                    @if(auth()->check() && auth()->user()->hasPermission('drivers.view'))
                    <li class="nav-item">
                        <a href="{{ route('admin.drivers.index') }}" class="nav-link {{ request()->routeIs('admin.drivers.*') ? 'active' : '' }}">
                            <i class="bi bi-person-badge-fill"></i>
                            <span>{{ __('drivers') }}</span>
                        </a>
                    </li>
                    @endif

                    @if(auth()->check() && auth()->user()->hasAnyPermission(['trips.view', 'trips.create', 'trips.edit']))
                    <li class="nav-item">
                        <a href="{{ route('admin.costs.index') }}" class="nav-link {{ request()->routeIs('admin.costs.*') ? 'active' : '' }}">
                            <i class="bi bi-currency-dollar"></i>
                            <span>{{ __('costs') }}</span>
                        </a>
                    </li>
                    @endif

                    <li class="nav-item">
                        <a href="{{ route('admin.tracking.index') }}" class="nav-link {{ request()->routeIs('admin.tracking.*') ? 'active' : '' }}">
                            <i class="bi bi-geo-alt-fill"></i>
                            <span>{{ __('Live Tracking') }}</span>
                        </a>
                    </li>
                </ul>
            </div>

            <!-- Analytics & Settings Section -->
            <div class="nav-section">
                <span class="nav-section-title">{{ __('Analytics & Settings') }}</span>
                <ul class="nav-menu">
                    @if(auth()->check() && auth()->user()->hasPermission('users.view'))
                    <li class="nav-item">
                        <a href="{{ route('admin.users.index') }}" class="nav-link {{ request()->routeIs('admin.users.*') ? 'active' : '' }}">
                            <i class="bi bi-people-fill"></i>
                            <span>{{ __('users') }}</span>
                        </a>
                    </li>
                    @endif

                    @if(auth()->check() && auth()->user()->hasPermission('roles.view'))
                    <li class="nav-item">
                        <a href="{{ route('admin.roles.index') }}" class="nav-link {{ request()->routeIs('admin.roles.*') ? 'active' : '' }}">
                            <i class="bi bi-shield-lock-fill"></i>
                            <span>{{ __('roles') }}</span>
                        </a>
                    </li>
                    @endif
                </ul>
            </div>
        </nav>

        <!-- Sidebar Footer - Theme Toggle -->
        <div class="sidebar-footer">
            <div class="theme-toggle" id="themeToggle">
                <i class="bi bi-sun-fill theme-icon-light"></i>
                <span class="theme-text">{{ __('Light Mode') }}</span>
                <i class="bi bi-moon-fill theme-icon-dark"></i>
            </div>
        </div>
    </aside>

    <!-- Main Content -->
    <div class="main-content" id="mainContent">
        <!-- Top Header -->
        <header class="top-header">
            <div class="header-left">
                <button class="sidebar-toggle d-lg-none" id="sidebarToggle" aria-label="Toggle sidebar">
                    <i class="bi bi-list"></i>
                </button>
                <div class="page-info">
                    <h1 class="page-title">@yield('page-title', __('dashboard'))</h1>
                    <p class="page-subtitle">@yield('page-subtitle', __('Welcome back! Here\'s your logistics overview.'))</p>
                </div>
            </div>
            <div class="header-right">
                <!-- Language Switcher -->
                <div class="language-dropdown dropdown">
                    <button class="btn btn-lang dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-globe2"></i>
                        <span>{{ strtoupper(app()->getLocale()) == 'EN' ? 'English' : (strtoupper(app()->getLocale()) == 'HI' ? 'हिंदी' : (strtoupper(app()->getLocale()) == 'ES' ? 'Español' : 'தமிழ்')) }}</span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item {{ app()->getLocale() == 'en' ? 'active' : '' }}" href="/lang/en"><span class="flag-icon">🇺🇸</span> English</a></li>
                        <li><a class="dropdown-item {{ app()->getLocale() == 'hi' ? 'active' : '' }}" href="/lang/hi"><span class="flag-icon">🇮🇳</span> हिंदी</a></li>
                        <li><a class="dropdown-item {{ app()->getLocale() == 'es' ? 'active' : '' }}" href="/lang/es"><span class="flag-icon">🇪🇸</span> Español</a></li>
                        {{-- <li><a class="dropdown-item {{ app()->getLocale() == 'ta' ? 'active' : '' }}" href="/lang/ta"><span class="flag-icon">🇮🇳</span> தமிழ்</a></li> --}}
                    </ul>
                </div>

             {{--    <!-- Notifications -->
                <div class="header-notifications dropdown">
                    <button class="btn btn-notification" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-bell"></i>
                        <span class="notification-badge">3</span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end notification-dropdown">
                        <li class="dropdown-header">Notifications</li>
                        <li><a class="dropdown-item" href="#"><i class="bi bi-truck text-primary"></i> New trip assigned</a></li>
                        <li><a class="dropdown-item" href="#"><i class="bi bi-box-seam text-success"></i> Shipment delivered</a></li>
                        <li><a class="dropdown-item" href="#"><i class="bi bi-exclamation-circle text-warning"></i> Pending approval</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item text-center" href="#">View all</a></li>
                    </ul>
                </div> --}}

                <!-- User Menu -->
                <div class="user-dropdown dropdown">
                    @if(auth()->check())
                    <button class="btn btn-user dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <div class="user-avatar">
                            {{ strtoupper(substr(auth()->user()->name, 0, 1)) }}
                        </div>
                        <span class="user-name d-none d-md-inline">{{ auth()->user()->name }}</span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end user-menu-dropdown">
                        <li class="dropdown-header">
                            <strong>{{ auth()->user()->name }}</strong>
                            @if(auth()->user()->roles->isNotEmpty())
                            <span class="badge bg-primary-subtle text-primary">{{ auth()->user()->roles->first()->display_name }}</span>
                            @endif
                        </li>
                      {{--   <li><hr class="dropdown-divider"></li> --}}
                      {{--   <li>
                            <a class="dropdown-item" href="#">
                                <i class="bi bi-person"></i> Profile
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="bi bi-gear"></i> Settings
                            </a>
                        </li> --}}
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form action="{{ route('admin.logout') }}" method="POST">
                                @csrf
                                <button type="submit" class="dropdown-item text-danger">
                                    <i class="bi bi-box-arrow-right"></i> {{ __('logout') }}
                                </button>
                            </form>
                        </li>
                    </ul>
                    @endif
                </div>
            </div>
        </header>

        <!-- Page Content -->
        <main class="content-wrapper">
            @yield('content')
        </main>
    </div>

    <!-- Sidebar Overlay for Mobile -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <!-- Bootstrap 5.3 JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Theme & Sidebar Script -->
    <script>
        // Theme Toggle
        const themeToggle = document.getElementById('themeToggle');
        const html = document.documentElement;
        const themeText = themeToggle.querySelector('.theme-text');
        
        // Check for saved theme preference
        const savedTheme = localStorage.getItem('theme') || 'light';
        html.setAttribute('data-theme', savedTheme);
        updateThemeText(savedTheme);
        
        themeToggle.addEventListener('click', () => {
            const currentTheme = html.getAttribute('data-theme');
            const newTheme = currentTheme === 'light' ? 'dark' : 'light';
            
            html.setAttribute('data-theme', newTheme);
            localStorage.setItem('theme', newTheme);
            updateThemeText(newTheme);
        });
        
        function updateThemeText(theme) {
            themeText.textContent = theme === 'light' ? '{{ __("Light Mode") }}' : '{{ __("Dark Mode") }}';
        }

        // Mobile Sidebar Toggle
        const sidebar = document.getElementById('sidebar');
        const sidebarToggle = document.getElementById('sidebarToggle');
        const sidebarOverlay = document.getElementById('sidebarOverlay');
        
        if (sidebarToggle) {
            sidebarToggle.addEventListener('click', () => {
                sidebar.classList.toggle('show');
                sidebarOverlay.classList.toggle('show');
            });
        }
        
        if (sidebarOverlay) {
            sidebarOverlay.addEventListener('click', () => {
                sidebar.classList.remove('show');
                sidebarOverlay.classList.remove('show');
            });
        }

        // Submenu Arrow Rotation
        document.querySelectorAll('.has-submenu > .nav-link').forEach(link => {
            link.addEventListener('click', function() {
                const arrow = this.querySelector('.submenu-arrow');
                const isExpanded = this.getAttribute('aria-expanded') === 'true';
                // Arrow rotation is handled by CSS
            });
        });
    </script>
    
    @stack('scripts')
</body>
</html>